<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Setup\Patch\Schema;

use Magento\Framework\Module\Manager as ModuleManager;
use Novuna\Pbf\Setup\Operation\UpdateAttributeAndConfigTo201;
use Novuna\Pbf\Setup\Operation\UpdateSchemaTo201;
use Magento\Framework\Module\ResourceInterface;
use Magento\Framework\Setup\Patch\SchemaPatchInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Novuna\Pbf\Setup\Patch\Data\ProductPbfEnableAttribute;

class UpdateTo201 implements SchemaPatchInterface
{
    /**
     * @var UpdateSchemaTo201
     */
    private UpdateSchemaTo201 $updateSchemaTo201;

    /**
     * @var ResourceInterface
     */
    private ResourceInterface $moduleResource;

    /**
     * @var SchemaSetupInterface
     */
    private SchemaSetupInterface $schemaSetup;
    private UpdateAttributeAndConfigTo201 $attributeAndConfigTo201;
    private ModuleManager $moduleManager;

    public function __construct(
        UpdateAttributeAndConfigTo201 $attributeAndConfigTo201,
        UpdateSchemaTo201 $updateSchemaTo201,
        ResourceInterface $moduleResource,
        SchemaSetupInterface $schemaSetup,
        ModuleManager $moduleManager
    ) {
        $this->attributeAndConfigTo201 = $attributeAndConfigTo201;
        $this->updateSchemaTo201 = $updateSchemaTo201;
        $this->moduleResource = $moduleResource;
        $this->schemaSetup = $schemaSetup;
        $this->moduleManager = $moduleManager;
    }

    public static function getDependencies(): array
    {
        return [ProductPbfEnableAttribute::class];
    }

    public function getAliases(): array
    {
        return [];
    }

    public function apply(): void
    {
        if (!$this->moduleManager->isEnabled('Hitachi_PaybyFinance') &&
            $this->IsModuleUpgradingFromOldVersion()) {
            $this->updateSchemaTo201->execute($this->schemaSetup);
            $this->attributeAndConfigTo201->execute($this->schemaSetup);
        }
    }

    //using old table columns identify module upgrade status
    private function IsModuleUpgradingFromOldVersion()
    {
        $updateTable = $this->schemaSetup->getTable('pbf_draft_order');

        if (!$this->schemaSetup->tableExists($updateTable)) {
            return false;
        }
        //if old version column exists then assume module already installed
        if ($this->schemaSetup->getConnection()->tableColumnExists($updateTable, 'finance_amount')) {
            return true;
        }
        return false;
    }
}
