<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Plugin\Payment\Model;

use Novuna\Pbf\Model\PaymentMethod\PaymentMethodAvailability;
use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Payment\Model\MethodList as Subject;

class MethodList
{
    private CheckoutSession $checkoutSession;
    private PaymentMethodAvailability $paymentMethodAvailability;

    public function __construct(
        CheckoutSession $checkoutSession,
        PaymentMethodAvailability $paymentMethodAvailability
    ) {
        $this->checkoutSession = $checkoutSession;
        $this->paymentMethodAvailability = $paymentMethodAvailability;
    }

    public function afterGetAvailableMethods(Subject $subject, $paymentMethodList)
    {
        foreach ($paymentMethodList as $i => $paymentMethod) {
            if (!$this->isMethodAvailable($paymentMethod)) {
                unset($paymentMethodList[$i]);
            }
        }
        return $paymentMethodList;
    }

    private function isMethodAvailable($paymentMethod): bool
    {
        $quote = $this->checkoutSession->getQuote();
        return $this->paymentMethodAvailability->isAvailableForQuote($paymentMethod->getCode(), $quote);
    }
}
