<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Observer\DraftOrder;

use Novuna\Pbf\Model\DraftOrder\Quote\QuoteConverter;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Quote\Model\Quote;
use Magento\Sales\Model\Order;

class CheckoutSubmitAllAfterObserver implements ObserverInterface
{
    private QuoteConverter $quoteConverter;

    public function __construct(QuoteConverter $quoteConverter)
    {
        $this->quoteConverter = $quoteConverter;
    }

    public function execute(Observer $observer): void
    {
        $quote = $observer->getEvent()->getData('quote');
        $order = $observer->getEvent()->getData('order');

        if ($quote->getPbfFinanceEnabled() && $quote instanceof Quote && $order instanceof Order) {
            $this->quoteConverter->connectDraftOrder($quote, $order);
        }
    }
}
