<?php

namespace Novuna\Pbf\Model\Queue;

use Magento\Framework\HTTP\Client\CurlFactory;
use Psr\Log\LoggerInterface;
use function PHPUnit\Framework\throwException;

class WebhookSender
{
    /**
     * @var LoggerInterface
     */
    private  $logger;
    private CurlFactory $curlFactory;

    public function __construct(
        LoggerInterface $logger,
        CurlFactory $curlFactory
    )
    {
        $this->logger = $logger;
        $this->curlFactory = $curlFactory;
    }

    public function processMessage(string $mqDataEnc)
    {
        $mqData = json_decode($mqDataEnc, true);
        $curl = $this->curlFactory->create();
        $headers = $mqData['headers'];
        $url = $mqData['url'];
        $data = $mqData['data'];

        $curl->setHeaders($headers);
        //When statusCode > 400 => throw exception:
        $curl->setOption(CURLOPT_FAILONERROR, 1); // difficult to combine return-error and throw-exception approaches, unify it to throw only

        $curl->post($url, json_encode($data));

        $this->logger->debug('Processed queue message');
    }

}