<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\Data;

use Novuna\Pbf\Api\Data\ScriptTagWrapperInterface;
use Novuna\Pbf\Api\Data\ScriptTagDataInterface;

/**
 * @api
 */
class ScriptTagWrapper implements ScriptTagWrapperInterface
{
    /** @var ScriptTagDataInterface[] */
    private $scriptTags;
    private $scriptTag;

    public function __construct(
        array $scriptTags = null
    ) {
        $this->scriptTags = $scriptTags;
    }

    /**
     * @return \Novuna\Pbf\Api\Data\ScriptTagDataInterface|null
     */
    public function getScriptTag(): ?\Novuna\Pbf\Api\Data\ScriptTagDataInterface
    {
        return $this->scriptTag;
    }

    public function setScriptTag(ScriptTagDataInterface $scriptTag)
    {
        $this->scriptTag = $scriptTag;
    }

    /**
     * @return \Novuna\Pbf\Api\Data\ScriptTagDataInterface[]|null
     */
    public function getScriptTags(): ?array
    {
        return $this->scriptTags;
    }
}
