<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Model;

use Magento\Cms\Block\Page;
use Magento\Framework\Model\AbstractModel;
use Novuna\Pbf\Api\Data\CmsPageDataInterface;
use Novuna\Pbf\Api\Data\WebhookDataInterface;
use Novuna\Pbf\Model\Data\WebhookData;
use Novuna\Pbf\Model\ResourceModel\Webhook as WebhookResource;

class CmsPage extends AbstractModel implements CmsPageDataInterface
{
    const FIELD_ID = 'id';
    const FIELD_IDENTIFIER = 'identifier';
    const FIELD_TITLE = 'title';
    const FIELD_CONTENT = 'content';
    const FIELD_ACTIVE = 'active';

    /**
     * @inheritDoc
     */
    protected function _construct()
    {
        $this->_init(\Magento\Cms\Model\ResourceModel\Page::class);
    }

    /**
     * @inheritDoc
     */
    public function getId(): ?int
    {
        $id = $this->getData(self::FIELD_ID);
        return $id ? (int)$id : null;
    }

    /**
     * @inheritDoc
     */
    public function setId($id)
    {
        return $this->setData(self::FIELD_ID, $id);
    }

    /**
     * @inheritDoc
     */
    public function getIdentifier(): ?string
    {
        $id = $this->getData(self::FIELD_IDENTIFIER);
    }

    /**
     * @inheritDoc
     */
    public function setIdentifier($identifier): void
    {
        $this->setData(self::FIELD_IDENTIFIER, $identifier);
    }

    /**
     * @inheritDoc
     */
    public function getTitle(): ?string
    {
        $id = $this->getData(self::FIELD_TITLE);
    }

    /**
     * @inheritDoc
     */
    public function setTitle($title): void
    {
        $this->setData(self::FIELD_TITLE, $title);
    }

    /**
     * @inheritDoc
     */
    public function getContent(): ?string
    {
        $id = $this->getData(self::FIELD_CONTENT);
    }

    /**
     * @inheritDoc
     */
    public function setContent($content): void
    {
        $this->setData(self::FIELD_CONTENT, $content);
    }

    /**
     * @inheritDoc
     */
    public function isActive(): bool
    {
        $id = $this->getData(self::FIELD_ACTIVE);
    }

    /**
     * @inheritDoc
     */
    public function setActive($active): void
    {
        $this->setData(self::FIELD_ACTIVE, $active);
    }
}
