<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Model\Api;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;
use Novuna\Pbf\Api\SettingsInterface;
use Novuna\Pbf\Model\StoreConfigProvider;
use Novuna\Pbf\Model\Data\SettingsWrapper;
use Novuna\Pbf\Api\Data\SettingsWrapperInterface;
use Novuna\Pbf\Model\Widget\PbfWidgetConfigProvider;
use Magento\Framework\App\RequestInterface;

class SettingsService implements SettingsInterface
{
    private StoreConfigProvider $storeConfigProvider;
    private PbfWidgetConfigProvider $pbfWidgetConfigProvider;
    private StoreManagerInterface $storeManager;
    private RequestInterface $request;

    public function __construct(
        StoreConfigProvider $storeConfigProvider,
        PbfWidgetConfigProvider $pbfWidgetConfigProvider,
        StoreManagerInterface $storeManager,
        RequestInterface $request
    ) {
        $this->storeConfigProvider = $storeConfigProvider;
        $this->pbfWidgetConfigProvider = $pbfWidgetConfigProvider;
        $this->storeManager = $storeManager;
        $this->request = $request;
    }

    /**
     * @inheritDoc
     */
    public function setSettings(string $settings): string
    {
        $scopeType = $this->getScopeType();
        $storeId = $this->storeManager->getStore()->getId();
        // decode doubly-encoded json object
        // double encoding required to bypass m2 api limitations
        $this->storeConfigProvider->setSettings(json_decode($settings, true), $scopeType, $storeId);
        return $settings;
    }

    /**
     * @inheritDoc
     */
    public function getSettings(): SettingsWrapperInterface
    {
        $scopeType = $this->getScopeType();
        $storeId = $this->storeManager->getStore()->getId();
        // doubly encode settings to be able to pass it through the api
        return new SettingsWrapper(json_encode($this->storeConfigProvider->getSettings($scopeType, $storeId)));
    }

    /**
     * @return mixed
     */
    private function getScopeType()
    {
        $scopeType = ScopeInterface::SCOPE_STORE;
        //no idea how to get that scope type other than checking the 'all':
        if (strpos($this->request->getRequestUri(), '/rest/all/') === 0) {
            $scopeType = ScopeConfigInterface::SCOPE_TYPE_DEFAULT;
        }
        return $scopeType;
    }
}
