<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Controller\ApplyPbf;

use Laminas\Uri\Uri;
use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Framework\App\Request\Http;
use Magento\Framework\Controller\Result\RawFactory;
use Magento\Framework\View\Result\PageFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Novuna\Pbf\Controller\PbfWidget;
use Novuna\Pbf\Model\Widget\PbfWidgetConfigProvider;

class Index extends PbfWidget implements HttpPostActionInterface, CsrfAwareActionInterface
{
    protected CheckoutSession $checkoutSession;

    public function __construct(
        PbfWidgetConfigProvider $pbfWidgetConfigProvider,
        PageFactory $resultPageFactory,
        Http $request,
        RawFactory $resultRawFactory,
        StoreManagerInterface $storeManager,
        Uri $uri,
        CheckoutSession $checkoutSession
    ) {
        parent::__construct(
            $pbfWidgetConfigProvider,
            $resultPageFactory,
            $request,
            $resultRawFactory,
            $storeManager,
            $uri
        );

        $this->checkoutSession = $checkoutSession;
    }


    protected function getRequestBody()
    {
        $content = json_decode($this->request->getContent(), true);

        $quote = $this->checkoutSession->getQuote();
        $billingAddress = $quote->getBillingAddress();

        $content['checkoutToken'] = $this->checkoutSession->getQuoteId();
        $content['billingAddress'] = $this->remapAddressFields($billingAddress->getData());
        $content['billingAddress']['Address'] = $billingAddress->getStreet();
        $content['postcode'] = $billingAddress->getPostcode();

        return json_encode($content);
    }

    private function remapAddressFields($address)
    {
        $fieldMap = [
            "street" => "Street",
            "telephone" => "Phone",
            "postcode" => "PostCode",
            "city" => "Town",
            "firstname" => "FirstName",
            "lastname" => "SurName",
        ];

        $remapped = [];
        foreach ($address as $k => $v) {
            $remapped[$fieldMap[$k] ?? $k] = $v;
        }

        return $remapped;
    }
}
