<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Controller\Adminhtml\Configuration;

use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\App\Config\Storage\WriterInterface;
use Magento\Framework\Phrase;
use Magento\Framework\View\Result\PageFactory;
use Magento\Store\Model\ScopeInterface;
use Novuna\Pbf\Model\StoreConfigProvider;
use Novuna\Pbf\Model\Widget\PbfWidgetConfigProvider;

class Index extends Base
{
    const ADMIN_RESOURCE = 'Novuna_Pbf::paybyfinance';
    private PageFactory $resultPageFactory;
    private WriterInterface $writerInterface;
    private PbfWidgetConfigProvider $pbfWidgetConfigProvider;

    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        WriterInterface $writerInterface,
        PbfWidgetConfigProvider $pbfWidgetConfigProvider
    ) {
        parent::__construct($context);

        $this->resultPageFactory = $resultPageFactory;
        $this->writerInterface = $writerInterface;
        $this->pbfWidgetConfigProvider = $pbfWidgetConfigProvider;

    }

    public function execute()
    {
        $result = $this->resultPageFactory->create();
        if ($result instanceof Page) {
            $result->setActiveMenu(self::ADMIN_RESOURCE);
            $result->getConfig()->getTitle()->prepend(new Phrase('PBF - Account Settings'));
        }
        
        if ($this->_request->getParam(StoreConfigProvider::DELETE_INSTALL_HMAC_PARAM) == 1) {
            list($scope, $scopeId) = $this->pbfWidgetConfigProvider->getAdminReqScopeAndId();
            switch ($scope) {
                case ScopeInterface::SCOPE_WEBSITE : $scope = ScopeInterface::SCOPE_WEBSITES; break;
                case ScopeInterface::SCOPE_STORE : $scope = ScopeInterface::SCOPE_STORES; break;
            }

            $this->writerInterface->delete(StoreConfigProvider::XML_PATH_PBF_INSTALL_HMAC, $scope, $scopeId);
        }
            
        return $result;
    }
}
