<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Api;

/**
 * @api
 */
interface ProductMetaInterface
{
    /**
     * Query PBF to validate product meta data
     * @param string[] $productIds
     * @return \Novuna\Pbf\Api\Data\ProductMetaInterface|null
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function getProductMetaData(
        array $productIds
    ): ?Data\ProductMetaInterface;
}
