<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Api;

use Novuna\Pbf\Model\ResourceModel\Webhook\Collection;

/**
 * CRUD interface.
 * @api
 * @since 100.0.2
 */
interface CmsPageRepositoryInterface
{
    /**
     * Retrieve CMSPage.
     *
     * @param string $handle
     * @return \Novuna\Pbf\Api\Data\CmsPageDataInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getByHandle(string $handle, $storeId = null): Data\CmsPageDataInterface;

    public function getAllPages($storeId = null): ?array;
}
