<?php
/**
 * Copyright © Digital Boutique. All rights reserved.
 * See LICENSE_DIGITAL_BOUTIQUE.txt for license details.
 */
declare(strict_types=1);

namespace Novuna\Pbf\Setup\Patch\Data;

use Novuna\Pbf\Model\Entity\Attribute\Source\EnablePbf;
use Novuna\Pbf\Setup\Patch\ProductAttributes;
use Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class ProductPbfEnableAttribute extends ProductAttributes implements DataPatchInterface
{
    public function getAttributeData(): array
    {
        return [
            'pbf_enable' => [
                'group' => self::ATTRIBUTE_GROUP,
                'type' => 'int',
                'backend' => '',
                'frontend' => '',
                'label' => 'Enable Novuna PaybyFinance',
                'input' => 'select',
                'class' => '',
                'source' => EnablePbf::class,
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'visible' => true,
                'required' => true,
                'user_defined' => false,
                'default' => EnablePbf::VALUE_CONFIGURATION,
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'used_in_product_listing' => true,
                'used_for_promo_rules' => true,
                'unique' => false,
                'apply_to' => ''
            ],
        ];
    }
}
