<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Plugin\DraftOrder\Model;

use Magento\Quote\Model\Quote;

class QuoteBeforeSavePlugin
{
    public function beforeBeforeSave(Quote $quote)
    {
        $email = $quote->getCustomerEmail();

        if (!$email) {
            $billingAddressEmail = $quote->getBillingAddress()->getEmail();
            if ($billingAddressEmail) {
                $quote->setCustomerEmail($billingAddressEmail);
                $quote->getShippingAddress()->setEmail($billingAddressEmail);
            }
        }
    }
}
