<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Observer\Payment;

use Magento\Framework\Event\ObserverInterface;

class AddPbfAmountItemObserver implements ObserverInterface
{
    /**
     * Add pbf amount to payment discount total
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        /** @var $cart \Magento\Payment\Model\Cart */
        $cart = $observer->getEvent()->getCart();
        $salesEntity = $cart->getSalesModel();
        $value = abs(floatval($salesEntity->getDataUsingMethod('pbf_finance_amount')));
        if ($value > 0.0001) {
            $cart->addDiscount(floatval($value));
        }
    }
}
