<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Observer\Order;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Model\ResourceModel\Attribute;

class InvoiceSaveAfterObserver implements ObserverInterface
{
    /**
     * @var Attribute
     */
    protected $attribute;

    /**
     * @param Attribute $attribute
     */
    public function __construct(
        Attribute $attribute
    ) {
        $this->attribute = $attribute;
    }

    /**
     * Update order finance_amount_invoiced attribute based on created invoice
     * used for event: sales_order_invoice_save_after
     *
     * @param Observer $observer
     * @return $this
     * @throws \Exception
     */
    public function execute(Observer $observer)
    {
        $invoice = $observer->getEvent()->getInvoice();
        $order = $invoice->getOrder();

        /**
         * Update finance_amount_invoiced only if invoice is just created
         */
        if ($invoice->getOrigData() === null && $invoice->getPbfFinanceAmount()) {
            $order->setPbfFinanceAmountInvoiced(
                $order->getPbfFinanceAmountInvoiced() + $invoice->getPbfFinanceAmount()
            );
        }
        /**
         * Because of order doesn't save second time, added forced saving below attributes
         */
        $this->attribute->saveAttribute($order, 'pbf_finance_amount_invoiced');
        return $this;
    }
}
