<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Observer\Order;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Model\Order\Creditmemo;
use Magento\Sales\Model\ResourceModel\Attribute;

class CreditmemoSaveAfterObserver implements ObserverInterface
{
    /**
     * @var Attribute
     */
    protected $attribute;

    /**
     * @param Attribute $attribute
     */
    public function __construct(
        Attribute $attribute
    ) {
        $this->attribute = $attribute;
    }

    /**
     * Refund process.
     *
     * @param Observer $observer
     * @return $this
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Exception
     */
    public function execute(Observer $observer)
    {
        /** @var Creditmemo $creditmemo */
        $creditmemo = $observer->getEvent()->getCreditmemo();
        $order = $creditmemo->getOrder();
        if ($creditmemo->getPbfFinanceAmount()) {
            $order->setPbfFinanceAmountRefunded(
                $order->getPbfFinanceAmountRefunded() + $creditmemo->getPbfFinanceAmount()
            );
            /**
             * Because of order doesn't save second time, added forced saving below attributes
             */
            $this->attribute->saveAttribute($order, 'pbf_finance_amount_refunded');
        }
        return $this;
    }
}
