<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\ResourceModel\SalesOrderMeta;

use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Novuna\Pbf\Model\SalesOrderMeta;
use Novuna\Pbf\Model\ResourceModel\SalesOrderMeta as SalesOrderMetaResource;

class Collection extends AbstractCollection
{
    /**
     * @var string
     */
    protected $_idFieldName = 'id';

    /**
     * Initialize resource
     */
    protected function _construct()
    {
        $this->_init(SalesOrderMeta::class, SalesOrderMetaResource::class);
        $this->_map['fields']['id'] = 'main_table.id';
    }
}
