<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Model\Api;

use Novuna\Pbf\Api\Data\WebhookDataInterface;
use Novuna\Pbf\Api\Data\WebhookWrapperInterface;
use Novuna\Pbf\Api\WebhookInterface;
use Novuna\Pbf\Api\WebhookRepositoryInterface;
use Novuna\Pbf\Model\Data\WebhookWrapper;

class WebhookService implements WebhookInterface
{
    private WebhookRepositoryInterface $webhookRepository;

    public function __construct(
        WebhookRepositoryInterface $webhookRepository
    ) {
        $this->webhookRepository = $webhookRepository;
    }

    /**
     * @inheritDoc
     */
    public function createWebhook(WebhookDataInterface $webhook): WebhookDataInterface
    {
        $webhook = $this->webhookRepository->save($webhook);
        return $webhook;
    }

    /**
     * @inheritDoc
     */
    public function getWebhooks(): WebhookWrapperInterface
    {
        return new WebhookWrapper($this->webhookRepository->getCollection()->getItems());
    }

    /**
     * @inheritDoc
     */
    public function deleteWebhook(int $webhookId): bool
    {
        $this->webhookRepository->deleteById($webhookId);
        return true;
    }
}
