<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Api;

use Novuna\Pbf\Model\ResourceModel\Webhook\Collection;

/**
 * CRUD interface.
 * @api
 * @since 100.0.2
 */
interface WebhookRepositoryInterface
{
    /**
     * Save webhook
     *
     * @param \Novuna\Pbf\Api\Data\WebhookDataInterface $webhook
     * @return \Novuna\Pbf\Api\Data\WebhookDataInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(Data\WebhookDataInterface $webhook): Data\WebhookDataInterface;

    /**
     * Retrieve webhook.
     *
     * @param int $webhookId
     * @return \Novuna\Pbf\Api\Data\WebhookDataInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById(int $webhookId): Data\WebhookDataInterface;

    /**
     * Retrieve all webhooks that have a topic.
     *
     * @param string $topic
     * @return Collection
     */
    public function getByTopic(string $topic): Collection;

    /**
     * @return Collection
     */
    public function getCollection(): Collection;

    /**
     * Delete webhook.
     *
     * @param \Novuna\Pbf\Api\Data\WebhookDataInterface $webhook
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function delete(Data\WebhookDataInterface $webhook): bool;

    /**
     * Delete webhook by ID.
     *
     * @param int $webhookId
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function deleteById(int $webhookId): bool;
}
