<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Api;

/**
 * PBF Order management interface.
 *
 * @api
 * @since 100.0.2
 */
interface OrderManagementInterface
{
    /**
     * @param int $id
     * @param string $type
     * @return \Magento\Sales\Api\Data\OrderAddressInterface|null
     */
    public function getAddress(int $id, string $type = 'billing'): ?\Magento\Sales\Api\Data\OrderAddressInterface;

    /**
     * Update address of a specified order.
     *
     * @param int $id The order ID.
     * @param \Magento\Sales\Api\Data\OrderAddressInterface $orderAddress
     * @return bool
     */
    public function updateAddresses(
        int $id,
        \Magento\Sales\Api\Data\OrderAddressInterface $orderAddress
    ): bool;

    /**
     * Adds a comment to a specified order.
     *
     * @param int $id The order ID.
     * @param \Magento\Sales\Api\Data\OrderStatusHistoryInterface[] $statusHistoryItems Status history comment.
     * @return bool
     */
    public function addComment($id, $statusHistoryItems);

}
