/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

/**
 * Finance amount summary block info
 */
define([
    'jquery',
    'ko',
    'Magento_Checkout/js/view/summary/abstract-total',
    'Magento_Checkout/js/model/totals'
], function ($, ko, Component, totals) {
    "use strict";
    return Component.extend({
        defaults: {
            template: 'Novuna_Pbf/checkout/totals'
        },
        totals: totals.totals(),

        isDisplayedPaybyfinance: function () {
            var financeVisible = false;
            var pbfSegment = totals.getSegment('pbf_finance_amount');
            if (pbfSegment && pbfSegment.extension_attributes) {
                financeVisible = pbfSegment.extension_attributes.visible;
            }
            return financeVisible;
        },
        getFinanceAmount: function () {
            financeAmount = 0;
            if (totals.getSegment('pbf_finance_amount')) {
                var financeAmount = totals.getSegment('pbf_finance_amount').value;
            }
            return this.getFormattedPrice(financeAmount);
        },
        /**
         * Used balance without any formatting
         *
         * @return {Number}
         */
        getPureValue: function () {
            var price = 0,
                segment;

            if (this.totals) {
                segment = totals.getSegment('pbf_finance_amount');

                if (segment) {
                    price = segment.value;
                }
            }

            return price;
        },

        /**
         * Used finance_amount with currency sign and localization
         *
         * @return {String}
         */
        getValue: function () {
            return this.getFormattedPrice(this.getPureValue());
        },

        /**
         * Availability status
         *
         * @returns {Boolean}
         */
        isAvailable: function () {
            return this.isFullMode() && this.getPureValue() != 0; //eslint-disable-line eqeqeq
        },
    });
});