<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Ui\DraftOrder\Component\Column;

use Magento\Ui\Component\Listing\Columns\Column;

class NotificationHistory extends Column
{
    public function prepareDataSource(array $dataSource): array
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $formattedComments = '';
                if (isset($item['pbf_draft_comments'])) {
                    $comments = json_decode($item['pbf_draft_comments'], true);
                    foreach ($comments as $key => $comment) {
                        $formattedComments .= $key . ' - ' . $comment['comment'];
                        $formattedComments .= "<br/><br/>";
                    }
                }

                $item['pbf_draft_comments'] = $formattedComments;
            }
        }

        return $dataSource;
    }
}
