<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Setup\Operation;

use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\SchemaSetupInterface;

/**
 * Update old table column reference to new
 */
class UpdateSchemaTo201
{

    private $setup;

    public function execute(SchemaSetupInterface $setup)
    {
        $this->setup = $setup;

        $tableSchemaUpdates = [
            [
                'table_name' => 'pbf_draft_order',
                'column_updates' => [
                    [
                        'old_column' => 'finance_amount',
                        'new_column' => 'pbf_finance_amount',
                        'definition' => [
                            Table::OPTION_TYPE => Table::TYPE_DECIMAL,
                            Table::OPTION_UNSIGNED => false,
                            Table::OPTION_NULLABLE => true,
                            Table::OPTION_PRECISION => 20,
                            Table::OPTION_SCALE => 4,
                            'comment' => 'PBF Finance Amount Used'
                        ]
                    ],
                ]
            ],
            [
                'table_name' => 'sales_creditmemo',
                'column_updates' => [
                    [
                        'old_column' => 'base_finance_amount',
                        'new_column' => 'pbf_base_finance_amount',
                        'definition' => [
                            Table::OPTION_TYPE => Table::TYPE_DECIMAL,
                            Table::OPTION_UNSIGNED => false,
                            Table::OPTION_NULLABLE => true,
                            Table::OPTION_PRECISION => 20,
                            Table::OPTION_SCALE => 4,
                            'comment' => 'Base Finance Amount'
                        ]
                    ],
                    [
                        'old_column' => 'finance_amount',
                        'new_column' => 'pbf_finance_amount',
                        'definition' => [
                            Table::OPTION_TYPE => Table::TYPE_DECIMAL,
                            Table::OPTION_UNSIGNED => false,
                            Table::OPTION_NULLABLE => true,
                            Table::OPTION_PRECISION => 20,
                            Table::OPTION_SCALE => 4,
                            'comment' => 'Finance Amount'
                        ]
                    ],
                ]
            ],
            [
                'table_name' => 'sales_invoice',
                'column_updates' => [
                    [
                        'old_column' => 'finance_enabled',
                        'new_column' => 'pbf_finance_enabled',
                        'definition' => [
                            'type' => Table::TYPE_BOOLEAN,
                            'nullable' => true,
                            'comment' => 'Is PayByFinance enabled'
                        ]
                    ],
                    [
                        'old_column' => 'base_finance_amount',
                        'new_column' => 'pbf_base_finance_amount',
                        'definition' => [
                            Table::OPTION_TYPE => Table::TYPE_DECIMAL,
                            Table::OPTION_UNSIGNED => false,
                            Table::OPTION_NULLABLE => true,
                            Table::OPTION_PRECISION => 20,
                            Table::OPTION_SCALE => 4,
                            'comment' => 'Base Finance Amount'
                        ]
                    ],
                    [
                        'old_column' => 'finance_amount',
                        'new_column' => 'pbf_finance_amount',
                        'definition' => [
                            Table::OPTION_TYPE => Table::TYPE_DECIMAL,
                            Table::OPTION_UNSIGNED => false,
                            Table::OPTION_NULLABLE => true,
                            Table::OPTION_PRECISION => 20,
                            Table::OPTION_SCALE => 4,
                            'comment' => 'Finance Amount'
                        ]
                    ],
                ]
            ],
            [
                'table_name' => 'sales_order_grid',
                'column_updates' => [
                    [
                        'old_column' => 'base_finance_amount',
                        'new_column' => 'pbf_base_finance_amount',
                        'definition' => [
                            Table::OPTION_TYPE => Table::TYPE_DECIMAL,
                            Table::OPTION_UNSIGNED => false,
                            Table::OPTION_NULLABLE => true,
                            Table::OPTION_PRECISION => 20,
                            Table::OPTION_SCALE => 4,
                            'comment' => 'Base Finance Amount'
                        ]
                    ],
                    [
                        'old_column' => 'finance_amount',
                        'new_column' => 'pbf_finance_amount',
                        'definition' => [
                            Table::OPTION_TYPE => Table::TYPE_DECIMAL,
                            Table::OPTION_UNSIGNED => false,
                            Table::OPTION_NULLABLE => true,
                            Table::OPTION_PRECISION => 20,
                            Table::OPTION_SCALE => 4,
                            'comment' => 'Finance Amount'
                        ]
                    ],
                ]
            ],
            [
                'table_name' => 'quote_address',
                'column_updates' => [
                    [
                        'old_column' => 'base_finance_amount',
                        'new_column' => 'pbf_base_finance_amount',
                        'definition' => [
                            Table::OPTION_TYPE => Table::TYPE_DECIMAL,
                            Table::OPTION_UNSIGNED => false,
                            Table::OPTION_NULLABLE => true,
                            Table::OPTION_PRECISION => 20,
                            Table::OPTION_SCALE => 4,
                            'comment' => 'Base Finance Amount'
                        ]
                    ],
                    [
                        'old_column' => 'finance_amount',
                        'new_column' => 'pbf_finance_amount',
                        'definition' => [
                            Table::OPTION_TYPE => Table::TYPE_DECIMAL,
                            Table::OPTION_UNSIGNED => false,
                            Table::OPTION_NULLABLE => true,
                            Table::OPTION_PRECISION => 20,
                            Table::OPTION_SCALE => 4,
                            'comment' => 'Finance Amount'
                        ]
                    ],
                ]
            ],
            [
                'table_name' => 'sales_order',
                'column_updates' => [
                    [
                        'old_column' => 'finance_enabled',
                        'new_column' => 'pbf_finance_enabled',
                        'definition' => [
                            'type' => Table::TYPE_BOOLEAN,
                            'nullable' => true,
                            'comment' => 'Is PayByFinance enabled'
                        ]
                    ],
                    [
                        'old_column' => 'base_finance_amount',
                        'new_column' => 'pbf_base_finance_amount',
                        'definition' => [
                            Table::OPTION_TYPE => Table::TYPE_DECIMAL,
                            Table::OPTION_UNSIGNED => false,
                            Table::OPTION_NULLABLE => true,
                            Table::OPTION_PRECISION => 20,
                            Table::OPTION_SCALE => 4,
                            'comment' => 'Base Finance Amount'
                        ]
                    ],
                    [
                        'old_column' => 'finance_amount',
                        'new_column' => 'pbf_finance_amount',
                        'definition' => [
                            Table::OPTION_TYPE => Table::TYPE_DECIMAL,
                            Table::OPTION_UNSIGNED => false,
                            Table::OPTION_NULLABLE => true,
                            Table::OPTION_PRECISION => 20,
                            Table::OPTION_SCALE => 4,
                            'comment' => 'Finance Amount'
                        ]
                    ],
                    [
                        'old_column' => 'finance_amount_invoiced',
                        'new_column' => 'pbf_finance_amount_invoiced',
                        'definition' => [
                            Table::OPTION_TYPE => Table::TYPE_DECIMAL,
                            Table::OPTION_UNSIGNED => false,
                            Table::OPTION_NULLABLE => true,
                            Table::OPTION_PRECISION => 20,
                            Table::OPTION_SCALE => 4,
                            'comment' => 'PBF Finance Amount Invoiced'
                        ]
                    ],
                    [
                        'old_column' => 'finance_amount_refunded',
                        'new_column' => 'pbf_finance_amount_refunded',
                        'definition' => [
                            Table::OPTION_TYPE => Table::TYPE_DECIMAL,
                            Table::OPTION_UNSIGNED => false,
                            Table::OPTION_NULLABLE => true,
                            Table::OPTION_PRECISION => 20,
                            Table::OPTION_SCALE => 4,
                            'comment' => 'PBF Finance Amount Refunded'
                        ]
                    ],
                ]
            ],
            [
                'table_name' => 'quote',
                'column_updates' => [
                    [
                        'old_column' => 'finance_enabled',
                        'new_column' => 'pbf_finance_enabled',
                        'definition' => [
                            'type' => Table::TYPE_BOOLEAN,
                            'nullable' => true,
                            'comment' => 'Is PayByFinance enabled'
                        ]
                    ],
                    [
                        'old_column' => 'deposit_2nd',
                        'new_column' => 'pbf_deposit_2nd',
                        'definition' => [
                            'type' => Table::TYPE_BOOLEAN,
                            'nullable' => true,
                            'comment' => 'Is PayByFinance enabled'
                        ]
                    ],
                    [
                        'old_column' => 'base_finance_amount',
                        'new_column' => 'pbf_base_finance_amount',
                        'definition' => [
                            Table::OPTION_TYPE => Table::TYPE_DECIMAL,
                            Table::OPTION_UNSIGNED => false,
                            Table::OPTION_NULLABLE => true,
                            Table::OPTION_PRECISION => 20,
                            Table::OPTION_SCALE => 4,
                            'comment' => 'Base Finance Amount'
                        ]
                    ],
                    [
                        'old_column' => 'finance_amount',
                        'new_column' => 'pbf_finance_amount',
                        'definition' => [
                            Table::OPTION_TYPE => Table::TYPE_DECIMAL,
                            Table::OPTION_UNSIGNED => false,
                            Table::OPTION_NULLABLE => true,
                            Table::OPTION_PRECISION => 20,
                            Table::OPTION_SCALE => 4,
                            'comment' => 'Finance Amount'
                        ]
                    ],
                    [
                        'old_column' => 'finance_excl_tax_amount',
                        'new_column' => 'pbf_finance_excl_tax_amount',
                        'definition' => [
                            Table::OPTION_TYPE => Table::TYPE_DECIMAL,
                            Table::OPTION_UNSIGNED => false,
                            Table::OPTION_NULLABLE => true,
                            Table::OPTION_PRECISION => 20,
                            Table::OPTION_SCALE => 4,
                            'comment' => 'PBF Finance Excl Tax Amount Used'
                        ]
                    ],
                    [
                        'old_column' => 'draft_order',
                        'new_column' => 'pbf_draft_order',
                        'definition' => [
                            'type' => Table::TYPE_BOOLEAN,
                            'nullable' => true,
                            'comment' => 'Is draft order'
                        ]
                    ],
                    [
                        'old_column' => 'draft_order_converted',
                        'new_column' => 'pbf_draft_order_converted',
                        'definition' => [
                            'type' => Table::TYPE_BOOLEAN,
                            'nullable' => true,
                            'comment' => 'Is draft order converted'
                        ]
                    ],
                    [
                        'old_column' => 'draft_order_converted_order_id',
                        'new_column' => 'pbf_draft_order_converted_order_id',
                        'definition' => [
                            'type' => Table::TYPE_TEXT,
                            'length' => 255,
                            'default' => 0,
                            'nullable' => true,
                            'comment' => 'Draft order comments'
                        ]
                    ],
                    [
                        'old_column' => 'draft_comments',
                        'new_column' => 'pbf_draft_comments',
                        'definition' => [
                            'type' => Table::TYPE_TEXT,
                            'nullable' => true,
                            'comment' => 'Draft order comments'
                        ]
                    ],
                ]
            ],
        ];

        try {
            $this->updateTables($tableSchemaUpdates);
        } catch (\Exception $e) {

        }
    }

    private function updateTables($tableSchemaUpdates)
    {
        foreach ($tableSchemaUpdates as $updates) {

            $tableName = $updates['table_name'] ?? '';
            $updateTable = $this->setup->getTable($tableName);

            if (!$this->setup->tableExists($updateTable)) {
                return;
            }
            $columnUpdates = $updates['column_updates'] ?? [];

            foreach ($columnUpdates as $columnUpdate) {
                $oldColumn = $columnUpdate['old_column'] ?? '';
                $newColumn = $columnUpdate['new_column'] ?? '';
                $definition = $columnUpdate['definition'] ?? '';

                if ($this->setup->getConnection()->tableColumnExists($updateTable, $newColumn) &&
                    $this->setup->getConnection()->tableColumnExists($updateTable, $oldColumn)) {
                    //drop column created by pbf module upgrade
                    $this->setup->getConnection()->dropColumn(
                        $updateTable,
                        $newColumn
                    );

                    //rename old column to new pbf column
                    $this->setup->getConnection()->changeColumn(
                        $updateTable,
                        $oldColumn,
                        $newColumn,
                        $definition
                    );
                }
            }
        }
    }
}