<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Plugin\DraftOrder\Model;

use Magento\Quote\Model\Quote;
use Novuna\Pbf\Model\DraftOrder\Quote\QuoteLocker;

class QuoteBlocker
{
    private QuoteLocker $quoteLocker;

    public function __construct(QuoteLocker $quoteLocker)
    {
        $this->quoteLocker = $quoteLocker;
    }

   /**
    * Prevent totals from being collected if we consider the quote locked for
    * the purposes of draft order.
    *
    * @param Quote $quote
    * @return Quote
    */
    public function beforeCollectTotals(Quote $quote)
    {
        if ($this->quoteLocker->isQuoteLocked($quote)) {
            $quote->setTotalsCollectedFlag(true);
        }

        return $quote;
    }
}
