<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Plugin\DraftOrder\Model;

use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Quote\Api\CartRepositoryInterface as QuoteRepository;

class CheckoutSessionPlugin
{
    private QuoteRepository $quoteRepository;

    public function __construct(QuoteRepository $quoteRepository)
    {
        $this->quoteRepository = $quoteRepository;
    }

    public function afterClearQuote(CheckoutSession $subject, $result)
    {
        if ($oldQuoteId = $subject->getData('old_quote_id')) {
            $oldQuote = $this->quoteRepository->get($oldQuoteId);
            if ($oldQuote) {
                $oldQuote->setIsActive(true);
                $this->quoteRepository->save($oldQuote);
                $subject->replaceQuote($oldQuote);
                $subject->setData('old_quote_id', null);
            }
        }

        return $result;
    }
}
