<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Plugin\Checkout\Model;

use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Quote\Api\Data\TotalsInterface;

class TotalsInformationManagement
{
    private CheckoutSession $checkoutSession;

    public function __construct(
        CheckoutSession $checkoutSession
    ) {
        $this->checkoutSession = $checkoutSession;
    }

    /**
     * @param \Magento\Checkout\Model\TotalsInformationManagement $subject
     * @param TotalsInterface $totals
     * @return TotalsInterface
     */
    public function afterCalculate(
        \Magento\Checkout\Model\TotalsInformationManagement $subject,
        TotalsInterface $totals
    ) {
        $this->checkoutSession->setShippingPrice($totals->getShippingAmount());
        $this->checkoutSession->setShippingPriceInclTax(
            $totals->getShippingAmount() + $totals->getShippingTaxAmount()
        );
        return $totals;
    }
}
