<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Observer;

use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Model\Order;
use Novuna\Pbf\Logger\PbfLoggerInterface;
use Novuna\Pbf\Model\StoreConfigProvider;

class QuoteSubmitBefore implements ObserverInterface
{
    private PbfLoggerInterface $logger;
    private StoreConfigProvider $storeConfigProvider;
    private CheckoutSession $checkoutSession;

    public function __construct(
        PbfLoggerInterface $logger,
        CheckoutSession $checkoutSession,
        StoreConfigProvider $storeConfigProvider
    ) {
        $this->checkoutSession = $checkoutSession;
        $this->logger = $logger;
        $this->storeConfigProvider = $storeConfigProvider;
    }

    public function execute(Observer $observer)
    {
        /** @var Order $order */
        $order = $observer->getOrder();
        $quote = $observer->getQuote();
        if ($order && $quote->getPbfFinanceEnabled()) {
            $order->setPbfFinanceEnabled(true);
            $order->setPbfAdditionalData($quote->getPbfAdditionalData());
            //Do we need this? Where is it used?
            //$order->setPbfWidgetSettings($this->checkoutSession->getPbfConfigData());

            $order->setPbfBaseFinanceAmount($quote->getPbfBaseFinanceAmount());
            $order->setPbfFinanceAmount($quote->getPbfFinanceAmount());
        }
    }
}
