<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Observer\Checkout;

use Magento\Checkout\Model\Session;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class QuoteInitAfter implements ObserverInterface
{

    private Session $checkoutSession;

    public function __construct(Session $checkoutSession)
    {
        $this->checkoutSession = $checkoutSession;
    }

    public function execute(Observer $observer)
    {
        /* @var \Magento\Quote\Model\Quote $quote */
        $quote = $observer->getEvent()->getQuote();

        if ($this->checkoutSession->getPbfFinanceEnabled()) {
            $quote->setPbfFinanceEnabled($this->checkoutSession->getPbfFinanceEnabled());
            $quote->setDepositSecond($this->checkoutSession->getPbfDeposit2nd());
        }
    }
}
