<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Model;

use Magento\Framework\Model\AbstractModel;
use Novuna\Pbf\Api\Data\OrderRiskDataInterface;
use Novuna\Pbf\Model\Data\WebhookData;

class OrderRisk extends AbstractModel implements OrderRiskDataInterface
{
    const FIELD_ID = 'id';
    const ORDER_ID = 'order_id';
    const MESSAGE = 'message';
    const SCORE = 'score';
    const RECOMMENDATION = 'recommendation';
    const FRAUD_CHECKED = 'pbf_fraud_checked';
    const USER_ACCEPTED_FRAUD = 'pbf_user_accepted_fraud';

    /**
     * @inheritDoc
     */
    protected function _construct()
    {
        $this->_init(\Novuna\Pbf\Model\ResourceModel\OrderRisk::class);
    }

    /**
     * @inheritDoc
     */
    public function getId(): ?int
    {
        $id = $this->getData(self::FIELD_ID);
        return $id ? (int)$id : null;
    }

    /**
     * @inheritDoc
     */
    public function setId($id)
    {
        return $this->setData(self::FIELD_ID, $id);
    }

    /**
     * @inheritDoc
     */
    public function setOrderId($orderId)
    {
        return $this->setData(self::ORDER_ID, $orderId);
    }

    public function getOrderId(): int
    {
        return (int)$this->getData(self::ORDER_ID);
    }

    /**
     * @inheritDoc
     */
    public function getMessage(): string
    {
        return $this->getData(self::MESSAGE);
    }

    /**
     * @inheritDoc
     */
    public function setMessage($message)
    {
        return $this->setData(self::MESSAGE, $message);
    }

    /**
     * @inheritDoc
     */
    public function getScore(): float
    {
        return (float)$this->getData(self::SCORE);
    }

    /**
     * @inheritDoc
     */
    public function setScore($score)
    {
        return $this->setData(self::SCORE, $score);
    }

    /**
     * @inheritDoc
     */
    public function getRecommendation(): string
    {
        return $this->getData(self::RECOMMENDATION);
    }

    /**
     * @inheritDoc
     */
    public function setRecommendation($recommendation)
    {
        return $this->setData(self::RECOMMENDATION, $recommendation);
    }

}
