<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Api;

use Magento\Framework\Webapi\Exception as WebapiException;

/**
 * @api
 */
interface OrderRisksInterface
{
    /**
     * POST request to create order risks on given order
     * @param int $id
     * @param \Novuna\Pbf\Api\Data\OrderRiskDataInterface $orderRisk
     * @return \Novuna\Pbf\Api\Data\OrderRiskWrapperInterface|null
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function createRisk(
        int $id,
        \Novuna\Pbf\Api\Data\OrderRiskDataInterface $orderRisk
    ): ?\Novuna\Pbf\Api\Data\OrderRiskWrapperInterface;

    /**
     * Query to get order risks on given order
     * @param int $id
     * @return \Novuna\Pbf\Api\Data\OrderRiskWrapperInterface|null
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function getRisks(
        int $id
    ): ?\Novuna\Pbf\Api\Data\OrderRiskWrapperInterface;

    /**
     * Delete order risks on given order
     * @param int $riskId
     * @return boolean have to returm something because of M2 expectations...
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function deleteRisk(
        int $riskId
    ): bool;

    /**
     * Delete all order risks on given order
     * @param int $id
     * @return boolean have to returm something because of M2 expectations...
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function deleteAllRisk(
        int $id
    ): bool;

    /**
     * Marks order as fraud checks were processed
     * @param int $id order ID
     * @return boolean have to return something because of M2 expectations...
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function markFraudChecked(
        int $id
    ): bool;

}
