define(['mage/utils/wrapper'], function(wrapper){
    'use strict';

    return function(target){

        var getInputFieldEmailValue = wrapper.wrap(target.getInputFieldEmailValue, function(original) {
            if (window.checkoutConfig.isDraftOrder) {
                return window.checkoutConfig.quoteData.customer_email;
            }
            return original();
        });

        var getShippingAddressFromData = wrapper.wrap(target.getShippingAddressFromData, function(original) {
            if (window.checkoutConfig.isDraftOrder) {
                return window.checkoutConfig.shippingAddressFromData;
            }
            return original();
        });

        target.getInputFieldEmailValue = getInputFieldEmailValue;
        target.getShippingAddressFromData = getShippingAddressFromData;

        return target;
    };
});
