<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Plugin\Sales\Api;

use Magento\Sales\Api\Data\InvoiceExtensionFactory;
use Magento\Sales\Api\Data\InvoiceInterface;
use Magento\Sales\Api\Data\InvoiceSearchResultInterface;
use Magento\Sales\Api\InvoiceRepositoryInterface;

class InvoiceRepositoryPlugin
{
    private InvoiceExtensionFactory $extensionFactory;

    /**
     * Init plugin
     *
     * @param InvoiceExtensionFactory $invoiceExtensionFactory
     */
    public function __construct(
        InvoiceExtensionFactory $invoiceExtensionFactory
    ) {
        $this->extensionFactory = $invoiceExtensionFactory;
    }

    protected function setExtensionAttributes(InvoiceInterface &$invoice)
    {
        $pbfAmount = $invoice->getData('finance_amount');
        /** @var \Magento\Sales\Api\Data\InvoiceExtension $extensionAttributes */
        $extensionAttributes = $invoice->getExtensionAttributes();
        if ($extensionAttributes === null) {
            $extensionAttributes = $this->extensionFactory->create();
        }

        $extensionAttributes->setFinanceAmount($pbfAmount);
        $invoice->setExtensionAttributes($extensionAttributes);
    }

    public function afterGet(
        InvoiceRepositoryInterface $subject,
        InvoiceInterface $resultEntity
    ) {
        $this->setExtensionAttributes($resultEntity);
        return $resultEntity;
    }

    public function afterGetList(
        InvoiceRepositoryInterface $subject,
        InvoiceSearchResultInterface $resultInvoice
    ) {
        $invoices = $resultInvoice->getItems();
        foreach ($invoices as &$invoice) {
            $this->setExtensionAttributes($invoice);
        }

        return $resultInvoice;
    }
}
