<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Plugin\Sales\Api;

use Magento\Sales\Api\CreditmemoRepositoryInterface;
use Magento\Sales\Api\Data\CreditmemoExtensionFactory;
use Magento\Sales\Api\Data\CreditmemoInterface;
use Magento\Sales\Api\Data\CreditmemoSearchResultInterface;

class CreditmemoRepositoryPlugin
{
    private CreditmemoExtensionFactory $extensionFactory;

    /**
     * Init plugin
     *
     * @param CreditmemoExtensionFactory $creditmemoExtensionFactory
     */
    public function __construct(
        CreditmemoExtensionFactory $creditmemoExtensionFactory
    ) {
        $this->extensionFactory = $creditmemoExtensionFactory;
    }

    protected function setExtensionAttributes(CreditmemoInterface &$creditmemo)
    {
        $pbfAmount = $creditmemo->getData('finance_amount');
        /** @var \Magento\Sales\Api\Data\CreditmemoExtension $extensionAttributes */
        $extensionAttributes = $creditmemo->getExtensionAttributes();
        if ($extensionAttributes === null) {
            $extensionAttributes = $this->extensionFactory->create();
        }

        $extensionAttributes->setFinanceAmount($pbfAmount);
        $creditmemo->setExtensionAttributes($extensionAttributes);
    }

    public function afterGet(
        CreditmemoRepositoryInterface $subject,
        CreditmemoInterface $resultEntity
    ) {
        $this->setExtensionAttributes($resultEntity);
        return $resultEntity;
    }

    public function afterGetList(
        CreditmemoRepositoryInterface $subject,
        CreditmemoSearchResultInterface $resultCreditmemo
    ) {
        $creditmemos = $resultCreditmemo->getItems();
        foreach ($creditmemos as &$creditmemo) {
            $this->setExtensionAttributes($creditmemo);
        }

        return $resultCreditmemo;
    }
}
