<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Plugin\Checkout\Controller\Cart;

use Magento\Checkout\Controller\Cart\CouponPost;
use Magento\Checkout\Model\Session as CheckoutSession;

class CouponPostPlugin
{
    private CheckoutSession $checkoutSession;

    public function __construct(CheckoutSession $checkoutSession)
    {
        $this->checkoutSession = $checkoutSession;
    }

    public function beforeExecute(CouponPost $subject)
    {
        $currentQuote = $this->checkoutSession->getQuote();
        $shippingAddress = $currentQuote->getShippingAddress();
        $currentQuote->setDiscountBeforeCouponApply($shippingAddress->getDiscountAmount());
    }
}
