<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Observer\Webhook;

use Magento\Sales\Model\Order;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Novuna\Pbf\Model\Webhooks\WebhookSender;

class SalesOrderCancel implements ObserverInterface
{
    private WebhookSender $webhookSender;

    public function __construct(
        WebhookSender $webhookSender
    ) {
        $this->webhookSender = $webhookSender;
    }

    public function execute(Observer $observer)
    {
        /** @var Order $order */
        $order = $observer->getOrder();

        if (!$order) {
            $order = $observer->getPayment()->getOrder();
        }

        if ($order && $order->getId() && $order->getFinanceEnabled()) {
            $this->webhookSender->SendOrderMessage($order->getId(), WebhookSender::ORDER_CANCEL, null);
        }
    }
}
