<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Observer\DraftOrder;

use Novuna\Pbf\Model\DraftOrder\Quote\QuoteConverter;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Quote\Api\CartRepositoryInterface as QuoteRepository;
use Magento\Quote\Model\Quote;
use Magento\Sales\Model\Order;

class SalesOrderPlaceAfter implements ObserverInterface
{
    private QuoteRepository $quoteRepository;
    private QuoteConverter $quoteConverter;

    public function __construct(
        QuoteRepository $quoteRepository,
        QuoteConverter $quoteConverter
    ) {
        $this->quoteRepository = $quoteRepository;
        $this->quoteConverter = $quoteConverter;
    }

    public function execute(Observer $observer): void
    {
        $order = $observer->getEvent()->getData('order');
        $quote = $observer->getEvent()->getData('quote');
        $this->quoteConverter->connectDraftOrder($quote, $order);
    }

    /*    public function execute(Observer $observer): void
        {
            $order = $observer->getEvent()->getData('order');
            if ($order instanceof Order) {
                $quote = $this->quoteRepository->get($order->getQuoteId());
                if ($quote instanceof Quote) {
                    $this->quoteConverter->convertQuote($quote, $order);
                }
            }
        }*/
}
