<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\Utils;

class TotalCalculateUtils
{
    /**
     * @phpcs:disable
     * Return true if given two floats are equal
     * Testing floating point values for equality is problematic, due to the way that they are represented internally.
     * To test floating point values for equality, an upper bound on the relative error due to rounding is used.
     * This value is known as the machine epsilon, or unit roundoff,
     * and is the smallest acceptable difference in calculations.
     * @param float $float1
     * @param float $float2
     * @return bool
     */
    public static function bcCompare(float $float1, float $float2): bool
    {
        $epsilon = 0.00001;
        return (abs($float1 - $float2) < $epsilon);
    }
}
