<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\Sales\Service;

use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Novuna\Pbf\Model\StoreConfigProvider;

class FraudCheckService
{
    const NOT_VERIFIED = "Not verified";
    const GOOD_TO_SHIP = "Ready to ship";
    const POSSIBLE_RISK = "Not Ready to Ship";

    const PBF_DECLINED_STATE = 'declined';

    public function canShip(bool $pbfFraudChecked, AbstractCollection $risks,  bool $pbfUserAcptedRisks): bool
    {
        return ($pbfFraudChecked && $risks->count() == 0) || $pbfUserAcptedRisks;
    }

    public function getPbfFraudStatusMessage(bool $pbfFraudChecked, AbstractCollection $risks, $detailed = true): array
    {
        if (!$pbfFraudChecked) {
            return [self::NOT_VERIFIED];
        }

        if ($risks->count() == 0) {
            return [self::GOOD_TO_SHIP];
        }

        if ($detailed) {
            $messages = [];
            foreach ($risks as $r) {
                $messages[] = $r->getMessage();
            }
            return $messages;
        }

        return [self::POSSIBLE_RISK];
    }
}
