<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\ResourceModel\DraftOrder\QuoteGrid;

use Magento\Framework\View\Element\UiComponent\DataProvider\SearchResult;

class Collection extends SearchResult
{
    protected $_idFieldName = 'id';

    /**
     * @return \Novuna\Pbf\Model\ResourceModel\DraftOrder\QuoteGrid\Collection
     */
    protected function _initSelect()
    {
        parent::_initSelect();

        $this->getSelect()
            ->joinLeft(
                ['order' => $this->getConnection()->getTableName('sales_order')],
                'main_table.quote_id = order.quote_id',
                ['order_id' => 'entity_id']
            );

        $this->getSelect()
            ->joinLeft(
                ['quote_address' => $this->getConnection()->getTableName('quote_address')],
                'main_table.quote_id = quote_address.quote_id',
                ['firstname', 'lastname', 'email']
            )
            ->where('quote_address.address_type =?', 'billing');


        $this->getSelect()
            ->joinLeft(
                ['quote' => $this->getConnection()->getTableName('quote')],
                'main_table.quote_id = quote.entity_id',
                ['store_id', 'is_active', 'draft_order_converted', 'draft_comments', 'pbf_application_number', 'pbf_state_ro']
            )->group('main_table.quote_id');

        return $this;
    }
}
