<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Model\Data;

use Novuna\Pbf\Api\Data\CommentWrapperInterface;
use Novuna\Pbf\Api\Data\WebhookDataInterface;

/**
 * @api
 */
class CommentWrapper implements CommentWrapperInterface
{
    private $items;

    public function __construct(
        array $items = []
    ) {
        $this->items = $items;
    }

    /**
     * @inheritDoc
     */
    public function getItems(): array
    {
        return $this->items;
    }
}
