<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\Api;

use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Webapi\Exception as WebapiException;
use Magento\Sales\Api\OrderRepositoryInterface;
use Novuna\Pbf\Api\Data\DraftOrderDataInterface;
use Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface;
use Novuna\Pbf\Api\Data\OrderMetaFieldWrapperInterface;
use Novuna\Pbf\Api\Data\OrderRiskDataInterface;
use Novuna\Pbf\Api\OrderMetaFieldsInterface;
use Novuna\Pbf\Api\OrderRiskRepositoryInterface;
use Novuna\Pbf\Api\OrderRisksInterface;
use Novuna\Pbf\Api\SalesOrderMetaRepositoryInterface;
use Novuna\Pbf\Model\Config\AppConfig;
use Novuna\Pbf\Model\Data\OrderMetaFieldWrapper;
use Novuna\Pbf\Model\Data\OrderRiskWrapper;
use Novuna\Pbf\Model\DraftOrder\DraftOrderMaker;
use Novuna\Pbf\Model\DraftOrderRepository;
use Novuna\Pbf\Model\Sales\Service\FraudCheckService;
use Novuna\Pbf\Model\StoreConfigProvider;
use Magento\Quote\Api\CartRepositoryInterface as QuoteRepository;

class OrderRisksService implements OrderRisksInterface
{
    private StoreConfigProvider $storeConfigProvider;
    private OrderRiskRepositoryInterface $orderRiskRepository;
    private OrderRepositoryInterface $orderRepository;

    public function __construct(
        OrderRiskRepositoryInterface $orderRiskRepository,
        StoreConfigProvider $storeConfigProvider,
        OrderRepositoryInterface $orderRepository
    ) {
        $this->orderRiskRepository = $orderRiskRepository;
        $this->storeConfigProvider = $storeConfigProvider;
        $this->orderRepository = $orderRepository;
    }

    public function createRisk(int $id, OrderRiskDataInterface $orderRisk
    ): ?\Novuna\Pbf\Api\Data\OrderRiskWrapperInterface {

        $resultOrderRisk = $this->orderRiskRepository->existRisk($id, $orderRisk);
        if ($resultOrderRisk == null) {
            $orderRisk->setOrderId($id);
            $resultOrderRisk = $this->orderRiskRepository->save($orderRisk);
        }

        $result = new OrderRiskWrapper();
        $result->setOrderRisk($resultOrderRisk);
        return $result;
    }

    public function getRisks(int $orderId
    ): ?\Novuna\Pbf\Api\Data\OrderRiskWrapperInterface {
        $risks = $this->orderRiskRepository->getOrderRisks($orderId);
        $result = new OrderRiskWrapper($risks->getItems());
        return $result;
    }

    public function deleteRisk(
        int $riskId
    ): bool {
        $this->orderRiskRepository->deleteById($riskId);
        return false; //do not use it, it's here because M2 needs some return value ;-(
    }

    public function deleteAllRisk(
        int $id
    ): bool
    {
        $this->orderRiskRepository->deleteAll($id);
        return false; //do not use it, it's here because M2 needs some return value ;-(
    }

    public function markFraudChecked(
        int $id
    ): bool
    {
        $order = $this->orderRepository->get($id);
        $order->setPbfFraudChecked(true);
        $this->orderRepository->save($order);
        return false; //do not use it, it's here because M2 needs some return value ;-(
    }

}
