<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Model\Api;

use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;
use Novuna\Pbf\Model\StoreConfigProvider;
use Novuna\Pbf\Api\InstallationTokenInterface;
use Novuna\Pbf\Model\Data\InstallationTokenData;
use Novuna\Pbf\Model\Data\InstallationTokenWrapper;
use Novuna\Pbf\Api\Data\InstallationTokenWrapperInterface;
use Magento\Store\Model\StoresConfig;
use Novuna\Pbf\Model\Widget\PbfWidgetConfigProvider;

class InstallationTokenService implements InstallationTokenInterface
{
    private StoreConfigProvider $storeConfigProvider;
    private StoresConfig $storesConfig;
    private PbfWidgetConfigProvider $pbfWidgetConfigProvider;
    private StoreManagerInterface $storeManager;

    public function __construct(
        StoreConfigProvider $storeConfigProvider,
        StoresConfig $storesConfig,
        PbfWidgetConfigProvider $pbfWidgetConfigProvider,
        StoreManagerInterface $storeManager
    ) {
        $this->storeConfigProvider = $storeConfigProvider;
        $this->storesConfig = $storesConfig;
        $this->pbfWidgetConfigProvider = $pbfWidgetConfigProvider;
        $this->storeManager = $storeManager;
    }

    /**
     * @inheritDoc
     */
    public function getInstallationToken(): InstallationTokenWrapperInterface
    {
        $storeId = $this->storeManager->getStore()->getId();
        
        return new InstallationTokenWrapper(
            new InstallationTokenData(
                $this->storeConfigProvider->getPbfInstallHmac(ScopeInterface::SCOPE_STORE, $storeId)
            )
        );
    }
}
