<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Helper;

use Magento\Framework\App\Helper\AbstractHelper;

class Data extends AbstractHelper
{
    /**
     * @param string $telephoneNumber
     * @return string
     */
    public function formatTelephoneNumber(string $telephoneNumber): string
    {
        if (substr($telephoneNumber, 0, 1) === '+') {
            $telephoneNumber = substr($telephoneNumber, 3);
        }
        $telephoneNumber = preg_replace("/[^0-9]/", "", $telephoneNumber);
        $telephoneNumber = ltrim($telephoneNumber, '0');
        $telephoneNumber = '0' . $telephoneNumber;
        if (strlen($telephoneNumber) < 10) {
            $telephoneNumber = str_pad($telephoneNumber, 10, 0);
        }

        return $telephoneNumber;
    }

    public static function calculateHMAC(array $params, $apiSecret)
    {
        ksort($params);
        $data = http_build_query($params);
        return hash_hmac('sha256', $data, $apiSecret);
    }

}
