<?php

namespace Mtc\WorldPay\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Mtc\Checkout\Contracts\InvoiceRepositoryContract;

/**
 * Class WorldPayController
 *
 * @package Mtc\WorldPay
 */
class WorldPayController extends Controller
{
    /**
     * Payment authorization page
     *
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function return($invoice_id, InvoiceRepositoryContract $invoice_repository)
    {
        /**
         * Form integration is a very nasty solution as it fires a backend request
         * with order details and the return to site at the same time. There is a config
         * on Worldpay admin page but gateway listens to it on occasion not always.
         * To prevent user seeing a failure page we have a very dirty workaround
         * of implementing wait time on response - when user lands on return page
         * we check whether payment has been processed. If not, we sleep for a wee while and
         * check again for number of times.
         */
        $attempts = 0;
        do {
            if ($attempts++ > 0) {
                sleep(config('worldpay.wait_time_seconds'));
            }
            $invoice_repository->load($invoice_id);
            $paid = $invoice_repository->isPaid();
            if ($paid) {
                return redirect()->to(URL::signedRoute('successful_payment', ['id' => $invoice_id ], null, config('app.env') === 'production'));
            }
        } while ($attempts < config('worldpay.wait_attempts'));

        return redirect()->to(route('failed_payment'));
    }
}
