<?php

namespace Mtc\WorldPay\Http\Controllers;

use Illuminate\Http\Request;
use Mtc\Checkout\Contracts\InvoiceRepositoryContract;
use Mtc\Checkout\Facades\Payment;
use Mtc\WorldPay\Http\Requests\WorldPayFormNotification;

/**
 * Class WorldPayApiController
 *
 * @package Mtc\WorldPay
 */
class WorldPayApiController
{

    /**
     * Charge the payment
     *
     * @param Request $request
     * @param InvoiceRepositoryContract $invoice_repository
     * @throws \Exception
     */
    public function charge(WorldPayFormNotification $request,  InvoiceRepositoryContract $invoice_repository)
    {
        $invoice_repository->load($request->input('cartId'));
        try {
            Payment::setActiveDriver('worldpay');
            $payment_details = Payment::charge($request, $invoice_repository);
            $invoice_repository->savePayment($payment_details);
            return response('Accepted', 200);

        } catch (\Exception $exception) {
            return abort(422);
        }
    }
}
