<?php

namespace Mtc\WorldPay\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

/**
 * Class WorldPayFormNotification
 *
 * @package Mtc\WorldPay
 */
class WorldPayFormNotification extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'cartId' => 'required|exists:invoices,id',
            'currency'=> 'required|alpha',
            'transStatus' => 'required',
            'transId' => 'required|numeric',
            'amount' => 'required|numeric',
            'callbackPW'=> [
                'required',
                Rule::in([
                    config('worldpay.callback_pw')
                ])
            ],
            'email' => 'email',
            'name' => 'present',
            'cardType' => 'present'
        ];
    }
}

