<?php

return [
    'enabled' => true,
    'live' => env('WORLDPAY_LIVE', false),

    /*
    |--------------------------------------------------------------------------
    | Redirect Form Payment Gateway keys
    |--------------------------------------------------------------------------
    |
    | Please set site specific keys in .env file
    | These keys are bound to mtc test account.
    | Production keys should never be part of tracked repo
    |
    */
    'secret_key' => env('WORLDPAY_FORM_SECRET_KEY', ''),
    'install_id' => env('WORLDPAY_FORM_INSTALL_ID', ''),
    'account_id' => env('WORLDPAY_FORM_ACCOUNT_ID', ''),
    'callback_pw' => env('WORLDPAY_FORM_CALLBACK_PASSWORD', ''),
    'order_key_string' =>  env('WORLDPAY_FORM_ORDER_KEY_STRING'),

    /*
    |--------------------------------------------------------------------------
    | Inline Form Payment Gateway keys
    |--------------------------------------------------------------------------
    |
    | Please set site specific keys in .env file
    | These keys are bound to mtc test account.
    | Production keys should never be part of tracked repo
    |
    */
    'public_key' => env('WORLDPAY_PUBLIC_KEY', 'T_C_f9a70a2d-2fc1-4c22-9255-de4d625f46e2'),
    'private_key' => env('WORLDPAY_PRIVATE_KEY', 'T_S_8693d335-f627-4a28-ae75-89e11f1dfc66'),

    /*
    |--------------------------------------------------------------------------
    | Applicable check
    |--------------------------------------------------------------------------
    |
    | Class that restricts whether payment gateway is available to given invoice
    |
    */
    'applicable_check_class' => \Mtc\WorldPay\WorldPayApplicableCheck::class,

    /*
    |--------------------------------------------------------------------------
    | Integration type
    |--------------------------------------------------------------------------
    |
    | WorldPay has multiple ways of integrating - key ones being:
    | WorldPay::VERSION_FORM - form that redirects away from site
    | WorldPay::VERSION_INLINE - inline form.
    |
    | Integration type depends on clients contract, they are not easily switchable
    |
    */
    'version' => \Mtc\WorldPay\WorldPay::VERSION_FORM,

    /*
    |--------------------------------------------------------------------------
    | Confirmation status
    |--------------------------------------------------------------------------
    |
    | Status that will be set on order when it is paid using this payment gateway.
    | Allows switching to "Awaiting Payment" or other statuses based on necessity.
    |
    */

    'confirmation_status' => 1,

    /*
    |--------------------------------------------------------------------------
    | Wait time setup for Fom integration
    |--------------------------------------------------------------------------
    |
    | Form integration is a very nasty solution as it fires a backend request
    | with order details and the return to site at the same time. There is a config
    | on Worldpay admin page but gateway listens to it on occasion not always.
    | To prevent user seeing a failure page we have a very dirty workaround
    | of implementing wait time on response - when user lands on return page
    | we check whether payment has been processed. If not, we sleep for a wee while and
    | check again for number of times.
    |
    */

    'wait_time_seconds' => 1,
    'wait_attempts' => 5,
];
