<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('valuations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->index()->nullable();
            $table->string('provider')->index();
            $table->string('registration')->index();
            $table->unsignedInteger('mileage')->index();
            $table->string('vehicle_type', 10)->nullable();
            $table->string('make', 50)->nullable();
            $table->string('model', 50)->nullable();
            $table->string('derivative')->nullable();
            $table->string('fuel_type', 50)->nullable();
            $table->string('engine_size', 50)->nullable();
            $table->string('body_type', 50)->nullable();
            $table->string('transmission', 50)->nullable();
            $table->date('date_of_registration')->nullable();
            $table->datetime('valuation_made_at')->nullable()->index();
            $table->decimal('retail_price', 10, 2)->nullable();
            $table->decimal('average_price', 10, 2)->nullable();
            $table->decimal('clean_price', 10, 2)->nullable();
            $table->decimal('below_price', 10, 2)->nullable();
            $table->text('errors')->nullable();
            $table->timestamps();
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('valuations');
    }
};
