<?php

namespace Mtc\VehicleValuation\Facades;

use App\Http\Requests\ValuationCustomerRequest;
use Illuminate\Support\Facades\Facade;
use Mtc\VehicleValuation\Models\VehicleValuation;
use Mtc\VehicleValuation\ValuationRepository;

/**
 * @method static VehicleValuation get(string $registration, string $mileage, ?string $variant = null, ?string $cosmetic_condition = null)
 * @method static bool hasEnabledDriver()
 * @method static bool hasFutureValuations()
 * @method static bool sendCustomerData(ValuationCustomerRequest $request, VehicleValuation $valuation)
 * @method static array getFutureValuation(VehicleValuation $valuation, int $mileage_per_year, string $condition)
 * @see ValuationRepository
 */
class Valuation extends Facade
{
    /**
     * Define the facade accessor
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'valuation-repository';
    }
}
