<?php

namespace Mtc\VehicleValuation\Config;

class AutoTraderConfig
{
    public function enabled(): bool
    {
        return !empty($this->apiKey()) && !empty($this->apiSecret());
    }

    public function apiKey(): string
    {
        return config('valuation.drivers.auto-trader.valuation_api_key')
        ?? config('valuation.drivers.auto-trader.api_key');
    }

    public function apiSecret(): string
    {
        return config('valuation.drivers.auto-trader.valuation_api_secret')
        ?? config('valuation.drivers.auto-trader.api_secret');
    }

    public function merchantId(): string
    {
        return config('valuation.drivers.auto-trader.merchant_id');
    }

    public function live(): bool
    {
        return config('valuation.drivers.auto-trader.live');
    }
}
